/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.rs6k;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.cim.provider.rs6k.HSCMProvWithRecoveryPlugin;
import com.ibm.hsc.cim.provider.rs6k.HscProviderUtils;
import com.ibm.hsc.cim.provider.rs6k.NVRAM;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.HscCecLock;
import com.ibm.hsc.common.util.HscLockManager;
import com.ibm.hsc.common.util.HscPerformance;
import com.ibm.hsc.common.util.HscProviderSocket;
import com.ibm.hsc.common.util.ProviderLceCommunication;
import com.ibm.hsc.common.util.VersionComparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMException;
import org.snia.wbem.cim.CIMNameSpace;
import org.snia.wbem.cim.CIMObjectPath;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbem.client.CIMClient;
import org.snia.wbem.client.CIMOMHandle;
import org.snia.wbem.provider.MethodProvider;
import org.snia.wbemcfg.GlobalConfig;

public class GetDLPARSysInfo
extends HSCMProvWithRecoveryPlugin
implements MethodProvider {
    public static final int SUCCESSFUL = 0;
    public static final int FAIL = -1;
    public static final String DLPAR_BUNDL_NAME = "DLAPRBundle";
    public static final String ERR_O_LMB_SIZE = HSCResourceBundleUtil.getMessage("DLAPRBundle", "ERR_O_LMB_SIZE", "HMCERRV3DLPAR000: LMB Size is 0");
    public static final String ERR_CANNOT_GET_LPAR_STATE = HSCResourceBundleUtil.getMessage("DLAPRBundle", "ERR_CANNOT_GET_LPAR_STATE", "HMCERRV3DLPAR001: Cannot get lpart states or definations");
    public static final String ERR_CANNOT_GET_CPU_INFO = HSCResourceBundleUtil.getMessage("DLAPRBundle", "ERR_CANNOT_GET_CPU_INFO", "HMCERRV3DLPAR002: Cannot get cpu info");
    public static final String ERR_CSP_MEM_OUT_SYNC = "The csp allocated memory and request memory is out of sync. The allocated memory is {0} MB. The paging table size is {1} MB. The requested memory is {2} MB. Restarts the logical partition to fix this problem.";

    public GetDLPARSysInfo() {
        super(false, null, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        CIMValue cIMValue;
        int n = HscPerformance.startTransaction("GetDLPARSysInfo++" + string);
        System.out.println("======== GetDLPARSysInfo: invokeMethod");
        String string2 = this.getCecName(cIMObjectPath);
        string2 = string2.trim();
        System.out.println("======== methodName: " + string + "  cecName: " + string2);
        HscLockManager hscLockManager = HscLockManager.GetHscProviderLockManager();
        HscCecLock hscCecLock = hscLockManager.getHscCecLock(string2);
        try {
            hscCecLock.Lock(hscLockManager.getLockType(string));
            cIMValue = super.invokeMethod(cIMObjectPath, string, vector, vector2);
            Object var11_10 = null;
            hscCecLock.Unlock();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            hscCecLock.Unlock();
            HscPerformance.endTransaction(n);
            throw throwable;
        }
        HscPerformance.endTransaction(n);
        return cIMValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CIMValue invokeMethod0(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        HscProviderSocket hscProviderSocket = null;
        try {
            String string2 = this.getCecName(cIMObjectPath);
            hscProviderSocket = this.getProviderSocket(string2);
            String string3 = this.getCSPVersion(cIMObjectPath);
            boolean bl = this.isCSPV1V2(cIMObjectPath);
            if (string.equals("getDLPARCPUInfo")) {
                this.getCpuInfo(cIMObjectPath, vector2, string2, hscProviderSocket, bl, string3);
            } else if (string.equals("getDLPARMemInfo")) {
                this.getMemInfo(cIMObjectPath, vector2, string2, hscProviderSocket, bl, string3);
            }
            CIMValue cIMValue = GetDLPARSysInfo.getCIMValueFromShort((short)0);
            Object var11_10 = null;
            if (hscProviderSocket != null) {
                hscProviderSocket.releaseLock();
            }
            return cIMValue;
        }
        catch (Throwable throwable) {
            block6: {
                Object var11_11 = null;
                if (hscProviderSocket == null) break block6;
                hscProviderSocket.releaseLock();
            }
            throw throwable;
        }
    }

    private void getMemInfo(CIMObjectPath cIMObjectPath, Vector vector, String string, HscProviderSocket hscProviderSocket, boolean bl, String string2) throws CIMException {
        Vector<UnsignedInt32> vector2 = new Vector<UnsignedInt32>();
        Vector<UnsignedInt32> vector3 = new Vector<UnsignedInt32>();
        Vector<UnsignedInt32> vector4 = new Vector<UnsignedInt32>();
        Vector<UnsignedInt32> vector5 = new Vector<UnsignedInt32>();
        Vector<String> vector6 = new Vector<String>();
        Vector<String> vector7 = new Vector<String>();
        String string3 = "";
        int n = this.getLMBSize(cIMObjectPath);
        if (n == 0) {
            throw new HSCCIMException(DLPAR_BUNDL_NAME, "ERR_O_LMB_SIZE", null);
        }
        Vector vector8 = this.getAllLparState(hscProviderSocket, string2);
        Vector vector9 = this.getAllLparDefinition(hscProviderSocket, string2);
        if (vector8 == null || vector9 == null) {
            throw new HSCCIMException(DLPAR_BUNDL_NAME, "ERR_CANNOT_GET_LPAR_STATE", null);
        }
        long l = this.getTotalAvailableMem(hscProviderSocket, string2);
        int n2 = (int)(l / (long)n);
        vector2.addElement(new UnsignedInt32((long)n2));
        vector3.addElement(new UnsignedInt32(0L));
        vector4.addElement(new UnsignedInt32(0L));
        vector5.addElement(new UnsignedInt32((long)n));
        vector6.addElement("");
        vector7.addElement(string);
        int n3 = 0;
        while (n3 < vector9.size()) {
            int n4 = (Integer)vector8.elementAt(n3);
            if (this.isRunning(n4)) {
                string3 = string3 + "1";
                Vector vector10 = this.getLparActiveProfile(hscProviderSocket, (short)(n3 + 1), string);
                vector3.addElement(this.getMinMem(vector10, bl, n));
                long[] lArray = this.getLparAllocMaxMem(hscProviderSocket, n3 + 1, string2);
                int n5 = (int)(lArray[0] / (long)n);
                vector2.addElement(new UnsignedInt32((long)n5));
                int n6 = (int)(lArray[1] / (long)n);
                vector4.addElement(new UnsignedInt32((long)n6));
                int n7 = (int)(lArray[2] / (long)n);
                vector5.addElement(new UnsignedInt32((long)n7));
                this.addParNames(vector7, vector6, string, hscProviderSocket, n3 + 1);
            } else {
                string3 = string3 + "0";
            }
            ++n3;
        }
        if (GlobalConfig.callMethodsWithValues) {
            vector.addElement(this.getIntCIMValueFromVector(vector2));
            vector.addElement(this.getIntCIMValueFromVector(vector5));
            vector.addElement(this.getIntCIMValueFromVector(vector3));
            vector.addElement(this.getIntCIMValueFromVector(vector4));
            vector.addElement(this.getStrCIMValueFromVector(vector7));
            vector.addElement(this.getStrCIMValueFromVector(vector6));
            vector.addElement(new CIMValue((Object)string3));
        } else {
            vector.addElement(new CIMProperty("allocatedMem", this.getIntCIMValueFromVector(vector2)));
            vector.addElement(new CIMProperty("requestMem", this.getIntCIMValueFromVector(vector5)));
            vector.addElement(new CIMProperty("minimumMem", this.getIntCIMValueFromVector(vector3)));
            vector.addElement(new CIMProperty("maximumMem", this.getIntCIMValueFromVector(vector4)));
            vector.addElement(new CIMProperty("parIntNames", this.getStrCIMValueFromVector(vector7)));
            vector.addElement(new CIMProperty("parNames", this.getStrCIMValueFromVector(vector6)));
            vector.addElement(new CIMProperty("runningLPARMask", new CIMValue((Object)string3)));
        }
    }

    private void getCpuInfo(CIMObjectPath cIMObjectPath, Vector vector, String string, HscProviderSocket hscProviderSocket, boolean bl, String string2) throws CIMException {
        Vector vector2;
        Vector<UnsignedInt8> vector3 = new Vector<UnsignedInt8>();
        Vector<UnsignedInt8> vector4 = new Vector<UnsignedInt8>();
        vector4.addElement(new UnsignedInt8(0));
        Vector<UnsignedInt8> vector5 = new Vector<UnsignedInt8>();
        vector5.addElement(new UnsignedInt8(0));
        Vector<UnsignedInt8> vector6 = new Vector<UnsignedInt8>();
        vector6.addElement(new UnsignedInt8(0));
        String string3 = "";
        Vector vector7 = this.getAllLparState(hscProviderSocket, string2);
        Vector vector8 = this.getAllLparDefinition(hscProviderSocket, string2);
        if (vector7 == null || vector8 == null) {
            throw new HSCCIMException(DLPAR_BUNDL_NAME, "ERR_CANNOT_GET_LPAR_STATE", null);
        }
        short[] sArray = new short[vector8.size() + 1];
        Vector[] vectorArray = new Vector[vector8.size() + 1];
        Vector[] vectorArray2 = new Vector[vector8.size() + 1];
        Vector[] vectorArray3 = new Vector[vector8.size() + 1];
        Vector[] vectorArray4 = new Vector[vector8.size() + 1];
        boolean[] blArray = new boolean[vector8.size() + 1];
        int n = 0;
        while (n < sArray.length) {
            sArray[n] = 0;
            vectorArray[n] = null;
            vectorArray2[n] = null;
            vectorArray3[n] = null;
            blArray[n] = false;
            vectorArray4[n] = null;
            ++n;
        }
        int n2 = 0;
        while (n2 < vector8.size()) {
            int n3 = (Integer)vector7.elementAt(n2);
            sArray[n2 + 1] = 0;
            blArray[n2] = this.isRunning(n3);
            if (blArray[n2]) {
                string3 = string3 + "1";
                vector2 = this.getLparActiveProfile(hscProviderSocket, (short)(n2 + 1), string);
                vector5.addElement(this.getMaxCpu(vector2, bl));
                vector4.addElement(this.getMinCpu(vector2, bl));
            } else {
                string3 = string3 + "0";
            }
            ++n2;
        }
        Vector vector9 = this.getAllCpuAssignment(hscProviderSocket, string2);
        vector2 = this.getAllCpuStates(hscProviderSocket, string2);
        Vector vector10 = this.getAllCpuStatus(hscProviderSocket, string2);
        if (sArray == null || vector2 == null || vector10 == null) {
            throw new HSCCIMException(DLPAR_BUNDL_NAME, "ERR_CANNOT_GET_CPU_INFO", null);
        }
        int n4 = 0;
        while (n4 < vector9.size()) {
            int n5 = (Integer)vector10.elementAt(n4);
            int n6 = (Integer)vector9.elementAt(n4);
            if (n6 > 0 && n6 <= vector8.size()) {
                int n7 = n6;
                sArray[n7] = (short)(sArray[n7] + 1);
            }
            int n8 = (Integer)vector2.elementAt(n4);
            if (this.isValidStatus(n5) && this.isCpuStopped(n8) && (n6 == 0 || !blArray[n6 - 1])) {
                sArray[0] = (short)(sArray[0] + 1);
            }
            if (!this.isRunning(n8) && n6 != 0 && blArray[n6 - 1]) {
                if (vectorArray[n6] == null) {
                    vectorArray2[n6] = new Vector();
                    vectorArray3[n6] = new Vector();
                    vectorArray[n6] = new Vector();
                    vectorArray4[n6] = new Vector();
                }
                vectorArray[n6].addElement(new UnsignedInt8((short)n4));
                vectorArray2[n6].addElement(new UnsignedInt8((short)n8));
                vectorArray3[n6].addElement(new UnsignedInt8((short)n5));
                vectorArray4[n6].addElement(new Integer(n6));
            }
            ++n4;
        }
        Vector vector11 = new Vector();
        Vector vector12 = new Vector();
        Vector vector13 = new Vector();
        Vector vector14 = new Vector();
        Vector vector15 = new Vector();
        int n9 = 0;
        while (n9 < vector8.size() + 1) {
            if (n9 == 0 || blArray[n9 - 1]) {
                vector3.addElement(new UnsignedInt8(sArray[n9]));
                if (vectorArray[n9] != null && vectorArray[n9].size() > 0) {
                    int n10 = 0;
                    while (n10 < vectorArray[n9].size()) {
                        vector11.addElement(vectorArray[n9].elementAt(n10));
                        vector12.addElement(vectorArray2[n9].elementAt(n10));
                        vector13.addElement(vectorArray3[n9].elementAt(n10));
                        this.addParNames(vector14, vector15, string, hscProviderSocket, (Integer)vectorArray4[n9].elementAt(n10));
                        ++n10;
                    }
                }
            }
            ++n9;
        }
        if (GlobalConfig.callMethodsWithValues) {
            vector.addElement(this.getCIMValueFromVector(vector3));
            vector.addElement(this.getCIMValueFromVector(vector4));
            vector.addElement(this.getCIMValueFromVector(vector5));
            vector.addElement(this.getCIMValueFromVector(vector11));
            vector.addElement(this.getCIMValueFromVector(vector12));
            vector.addElement(this.getCIMValueFromVector(vector13));
            vector.addElement(this.getStrCIMValueFromVector(vector14));
            vector.addElement(this.getStrCIMValueFromVector(vector15));
            vector.addElement(new CIMValue((Object)string3));
        } else {
            vector.addElement(new CIMProperty("allocatedCPU", this.getCIMValueFromVector(vector3)));
            vector.addElement(new CIMProperty("minimumCPU", this.getCIMValueFromVector(vector4)));
            vector.addElement(new CIMProperty("maximumCPU", this.getCIMValueFromVector(vector5)));
            vector.addElement(new CIMProperty("stoppedCPUIds", this.getCIMValueFromVector(vector11)));
            vector.addElement(new CIMProperty("stoppedCPUStates", this.getCIMValueFromVector(vector12)));
            vector.addElement(new CIMProperty("stoppedCPUStatus", this.getCIMValueFromVector(vector13)));
            vector.addElement(new CIMProperty("parIntNames", this.getStrCIMValueFromVector(vector14)));
            vector.addElement(new CIMProperty("parNames", this.getStrCIMValueFromVector(vector15)));
            vector.addElement(new CIMProperty("runningLPARMask", new CIMValue((Object)string3)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addParNames(Vector vector, Vector vector2, String string, HscProviderSocket hscProviderSocket, int n) throws CIMException {
        String string2 = "" + n;
        while (string2.length() < 3) {
            string2 = "0" + string2;
        }
        vector.addElement(string2 + "*" + string);
        boolean bl = false;
        try {
            bl = this.lockCsp(hscProviderSocket, 10);
            String string3 = ((NVRAM)NVRAM.NVRAM_TABLE.get(string)).getPartitionName(n, hscProviderSocket);
            vector2.addElement(string3);
            Object var10_9 = null;
            if (bl) {
                this.unlockCsp(hscProviderSocket);
            }
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (bl) {
                this.unlockCsp(hscProviderSocket);
            }
            throw throwable;
        }
    }

    private CIMValue getCIMValueFromVector(Vector vector) {
        UnsignedInt8[] unsignedInt8Array = new UnsignedInt8[vector.size()];
        unsignedInt8Array = vector.toArray(unsignedInt8Array);
        return new CIMValue((Object)unsignedInt8Array, new CIMDataType(21));
    }

    private CIMValue getIntCIMValueFromVector(Vector vector) {
        UnsignedInt32[] unsignedInt32Array = new UnsignedInt32[vector.size()];
        unsignedInt32Array = vector.toArray(unsignedInt32Array);
        return new CIMValue((Object)unsignedInt32Array, new CIMDataType(25));
    }

    private CIMValue getStrCIMValueFromVector(Vector vector) {
        return new CIMValue(vector, new CIMDataType(29));
    }

    private UnsignedInt8 getPropValueFromVector(Vector vector, int n) {
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(n);
        return (UnsignedInt8)cIMProperty.getValue().getValue();
    }

    private UnsignedInt8 getMaxCpu(Vector vector, boolean bl) {
        int n = bl ? 4 : 8;
        return this.getPropValueFromVector(vector, n);
    }

    private UnsignedInt8 getMinCpu(Vector vector, boolean bl) {
        int n = bl ? 5 : 7;
        return this.getPropValueFromVector(vector, n);
    }

    private UnsignedInt32 getMaxMem(Vector vector, boolean bl, int n) {
        int n2 = bl ? 6 : 11;
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(n2);
        int n3 = this.getIntValueFromProp(cIMProperty, n);
        return new UnsignedInt32((long)n3);
    }

    private UnsignedInt32 getMinMem(Vector vector, boolean bl, int n) {
        int n2 = bl ? 7 : 10;
        CIMProperty cIMProperty = (CIMProperty)vector.elementAt(n2);
        int n3 = this.getIntValueFromProp(cIMProperty, n);
        return new UnsignedInt32((long)n3);
    }

    private static CIMValue getCIMValueFromShort(short s) {
        UnsignedInt8 unsignedInt8 = new UnsignedInt8(s);
        return new CIMValue((Object)unsignedInt8, new CIMDataType(1));
    }

    private int getIntValueFromProp(CIMProperty cIMProperty, int n) {
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)cIMProperty.getValue().getValue();
        int n2 = unsignedInt32.intValue();
        return n2 / n;
    }

    private boolean isValidStatus(int n) {
        return n == 1 || n == 3;
    }

    private boolean isCpuStopped(int n) {
        return n == 7;
    }

    private boolean isRunning(int n) {
        return n == 8;
    }

    private Vector getAllLparState(HscProviderSocket hscProviderSocket, String string) throws CIMException {
        Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_ALL_LPARS_STATE", null, hscProviderSocket, string);
        if (hashtable != null && hashtable.size() > 0) {
            return (Vector)hashtable.get("ALL_LPAR_STATE");
        }
        return null;
    }

    private Vector getAllLparDefinition(HscProviderSocket hscProviderSocket, String string) throws CIMException {
        Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_ALL_LPAR_DEFINITION_FIELDS", null, hscProviderSocket, string);
        if (hashtable == null || hashtable.size() < 1) {
            return null;
        }
        Vector vector = (Vector)hashtable.get("ALL_LPAR_DEFINITION_FIELDS");
        int n = (Integer)hashtable.get("NUM_LPAR_SLOTS");
        if (n < 1) {
            return null;
        }
        Vector<Integer> vector2 = new Vector<Integer>();
        int n2 = 0;
        while (n2 < n) {
            Hashtable hashtable2 = (Hashtable)vector.elementAt(n2);
            vector2.addElement((Integer)hashtable2.get("SLOT_DEFINITION"));
            ++n2;
        }
        return vector2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector getLparActiveProfile(HscProviderSocket hscProviderSocket, short s, String string) throws CIMException {
        Object var4_4 = null;
        boolean bl = false;
        try {
            bl = this.lockCsp(hscProviderSocket, 10);
            Vector vector = ((NVRAM)NVRAM.NVRAM_TABLE.get(string)).getActivatedLPARProfile(s, hscProviderSocket);
            Object var8_7 = null;
            if (bl) {
                this.unlockCsp(hscProviderSocket);
            }
            return vector;
        }
        catch (Throwable throwable) {
            block3: {
                Object var8_8 = null;
                if (!bl) break block3;
                this.unlockCsp(hscProviderSocket);
            }
            throw throwable;
        }
    }

    private Vector getAllCpuStatus(HscProviderSocket hscProviderSocket, String string) throws CIMException {
        Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_PROCESSORS_STATUS_VALUES", null, hscProviderSocket, string);
        if (hashtable == null || hashtable.size() < 1) {
            return null;
        }
        return (Vector)hashtable.get("ALL_PROC_STATUS");
    }

    private Vector getAllCpuStates(HscProviderSocket hscProviderSocket, String string) throws CIMException {
        Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_INSTALLED_PROC_STATE_VALUE", null, hscProviderSocket, string);
        if (hashtable == null || hashtable.size() < 1) {
            return null;
        }
        return (Vector)hashtable.get("ALL_PROC_STATE");
    }

    private Vector getAllCpuAssignment(HscProviderSocket hscProviderSocket, String string) throws CIMException {
        Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_ALL_PROC_LPAR_ASSIGN_VALUE", null, hscProviderSocket, string);
        if (hashtable == null || hashtable.size() < 1) {
            return null;
        }
        return (Vector)hashtable.get("ALL_PROC_ASSIGNMENT");
    }

    private long[] getLparAllocMaxMem(HscProviderSocket hscProviderSocket, int n, String string) throws CIMException {
        Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_LPAR_MEMORY_RESOURCES", new String[]{Integer.toHexString(n)}, hscProviderSocket, string);
        System.out.println("lparId: " + n);
        long l = (Long)hashtable.get("TOT_ALLOC_MEMORY");
        System.out.println("Allocated memory: " + l);
        long l2 = (Long)hashtable.get("PAGE_TABLE_ALLOC_MEMORY");
        System.out.println("Page table memory: " + l2);
        Long l3 = (Long)hashtable.get("TOT_MEMORY_REQUESTED");
        long l4 = l3 == null ? l : l3;
        System.out.println("Request memory: " + l4);
        long l5 = (Long)hashtable.get("POSSIBLE_MEMORY");
        System.out.println("MAX activated memory: " + l5);
        long[] lArray = new long[3];
        lArray[2] = l4;
        lArray[1] = l5;
        lArray[0] = l - l2;
        return lArray;
    }

    private long getTotalAvailableMem(HscProviderSocket hscProviderSocket, String string) throws CIMException {
        Hashtable hashtable = HscProviderUtils.doCSPCommand("GET_CEC_MEMORY_RESOURCES", null, hscProviderSocket, string);
        return (Long)hashtable.get("TOT_AVAILABLE_MEMORY");
    }

    private HscProviderSocket getProviderSocket(String string) throws CIMException {
        if (string != null) {
            return ProviderLceCommunication.obtainSocket(string);
        }
        return null;
    }

    private String getCecName(CIMObjectPath cIMObjectPath) {
        Vector vector = cIMObjectPath.getKeys();
        int n = 0;
        while (n < vector.size()) {
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(n);
            if (cIMProperty.getName().equals("Name")) {
                return (String)cIMProperty.getValue().getValue();
            }
            ++n;
        }
        return null;
    }

    private boolean isCSPV1V2(CIMObjectPath cIMObjectPath) throws CIMException {
        String string = this.getCSPVersion(cIMObjectPath);
        int n = VersionComparator.CSPVersionValue(string);
        return n < 3000;
    }

    private String getCSPVersion(CIMObjectPath cIMObjectPath) throws CIMException {
        return (String)this.mCIMOMHandle.getProperty(cIMObjectPath, "CSPVersion").getValue();
    }

    private int getLMBSize(CIMObjectPath cIMObjectPath) throws CIMException {
        UnsignedInt32 unsignedInt32 = (UnsignedInt32)this.mCIMOMHandle.getProperty(cIMObjectPath, "LMBSize").getValue();
        return unsignedInt32.intValue();
    }

    private boolean lockCsp(HscProviderSocket hscProviderSocket, int n) throws CIMException {
        while (n > -1) {
            Hashtable hashtable = HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{Integer.toString(1), HscProviderUtils.getHscID((CIMOMHandle)this.mCIMOMHandle)}, hscProviderSocket);
            if (hashtable != null) {
                return true;
            }
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return false;
    }

    private void unlockCsp(HscProviderSocket hscProviderSocket) {
        try {
            HscProviderUtils.doCSPCommand("SET_LOCK_VALUE", new String[]{Integer.toString(2), HscProviderUtils.getHscID((CIMOMHandle)this.mCIMOMHandle)}, hscProviderSocket);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] stringArray) {
        block12: {
            CIMClient cIMClient = null;
            if (stringArray.length != 2) {
                System.out.println("Usage: java com.ibm.hsc.cim.provider.rs6k.GetDLPARSysInfo slotId hostName");
                System.exit(0);
            }
            short s = Short.parseShort(stringArray[0]);
            String string = "hscroot";
            String string2 = "abc123";
            CIMNameSpace cIMNameSpace = GetDLPARSysInfo.getCIMNameSpace(stringArray[1], "root/ibmhscV3_2");
            cIMClient = new CIMClient(cIMNameSpace, string, string2);
            CIMObjectPath cIMObjectPath = GetDLPARSysInfo.getCIMObjectPath(cIMClient);
            Vector<CIMProperty> vector = new Vector<CIMProperty>();
            CIMValue cIMValue = GetDLPARSysInfo.getCIMValueFromShort(s);
            System.out.println("inarg: " + ((UnsignedInt8)cIMValue.getValue()).shortValue());
            vector.addElement(new CIMProperty("LPARSlotID", cIMValue));
            Vector vector2 = new Vector();
            CIMValue cIMValue2 = cIMClient.invokeMethod(cIMObjectPath, "getDLPARCPUInfo", vector, vector2);
            GetDLPARSysInfo.dispRtnValues(vector2);
            vector2 = new Vector();
            cIMValue2 = cIMClient.invokeMethod(cIMObjectPath, "getDLPARMemInfo", new Vector(), vector2);
            GetDLPARSysInfo.dispRtnValues(vector2);
            Object var12_12 = null;
            try {
                if (cIMClient != null) {
                    cIMClient.close();
                }
                break block12;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block12;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var12_13 = null;
                    try {
                        if (cIMClient != null) {
                            cIMClient.close();
                        }
                        break block12;
                    }
                    catch (Exception exception2) {
                        exception2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    if (cIMClient != null) {
                        cIMClient.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public static void dispRtnValues(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            CIMProperty cIMProperty = (CIMProperty)vector.elementAt(n);
            System.out.println("out param[" + n + "]: " + cIMProperty.getName());
            Object object = cIMProperty.getValue().getValue();
            if (object instanceof UnsignedInt8) {
                System.out.println("value(uint8): " + ((UnsignedInt8)object).intValue());
            } else if (object instanceof UnsignedInt32) {
                System.out.println("value(uint32): " + ((UnsignedInt32)object).intValue());
            } else if (object instanceof Vector) {
                Vector vector2 = (Vector)object;
                int n2 = 0;
                while (n2 < vector2.size()) {
                    UnsignedInt8 unsignedInt8;
                    Object e = vector2.elementAt(n2);
                    if (e instanceof UnsignedInt8) {
                        unsignedInt8 = (UnsignedInt8)e;
                        System.out.println("value[" + n2 + "]:" + unsignedInt8.intValue());
                    } else if (e instanceof UnsignedInt32) {
                        unsignedInt8 = (UnsignedInt32)e;
                        System.out.println("value[" + n2 + "]:" + unsignedInt8.intValue());
                    } else {
                        System.out.println("value[" + n2 + "]:" + e);
                    }
                    ++n2;
                }
            } else if (object instanceof String) {
                System.out.println("value(string): " + object);
            } else {
                System.out.println("value object type:" + object.getClass().getName());
            }
            ++n;
        }
    }

    private static CIMObjectPath getCIMObjectPath(CIMClient cIMClient) throws Exception {
        CIMObjectPath cIMObjectPath = new CIMObjectPath("IBMHSC_ComputerSystem");
        cIMObjectPath.setNameSpace("root/ibmhscV3_2");
        Enumeration enumeration = cIMClient.enumInstances(cIMObjectPath, true);
        return (CIMObjectPath)enumeration.nextElement();
    }

    private static CIMNameSpace getCIMNameSpace(String string, String string2) {
        return new CIMNameSpace(string, string2);
    }
}

